$(document).ready(function () {
    // Function to handle TOC state persistence
    function updateTocState(state) {
        sessionStorage.setItem("tocState", state);
    }

    // Check and apply persisted TOC state
    if (sessionStorage.getItem("tocState") === "hidden") {
        $("button.toggle-toc-on-button").show();
        $("button.toggle-toc-off-button").hide();
        $(".sidenav-wrapper").hide();
    } else {
        $("button.toggle-toc-off-button").show();
        $("button.toggle-toc-on-button").hide();
        $(".sidenav-wrapper").show();
    }

    // TOC Hide
    $("button.toggle-toc-off-button").on("click touch", function () {
        $("button.toggle-toc-on-button").show();
        $(this).hide();
        $(".sidenav-wrapper").toggle();
        updateTocState("hidden");
    });

    // TOC Show
    $("button.toggle-toc-on-button").on("click touch", function () {
        $(this).hide();
        $("button.toggle-toc-off-button").show();
        $(".sidenav-wrapper").toggle();
        updateTocState("visible");
    });

    $("button.toggle-hoax-off-button").on("click touch", function () {
        $(this).hide();
        $("button.toggle-hoax-on-button").show();
        $("span.boul").toggleClass("show");
    });

    $("button.toggle-hoax-on-button").on("click touch", function () {
        $("button.toggle-hoax-off-button").show();
        $(this).hide();
        $("span.boul").toggleClass("show");
    });
});
